#ifndef __XMLFILE_H__
#define __XMLFILE_H__

#include <string>
#include "rapidxml.hpp"
using namespace rapidxml;

class XMLFile {
	typedef xml_document<> _Doc;
	typedef xml_node<> _Node;
	typedef xml_attribute<> _Att;
public:
	XMLFile(const char *_filePath);
	~XMLFile();

	void AppendChild(const char *childName);
	bool AppendAttribute(const char *name, const char *value);

	bool SetNodeValue(const char *value);

	void SelectFirstChild();
	void SelectLastChild();
	void SelectParent();
	void SelectRoot();

	void Print();

private:
	char* xml_string(const char *s) { 
		return doc.allocate_string(s);
	}
	std::string filePath;

	_Doc doc;
	_Node *node;
};

#endif